/**
 * @author Gulzar
 * Date 19/09/14
 * */

package ibase.ejb;

import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.rmi.RemoteException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12EvaluateExpression;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.JMSLogger;
import ibase.webitm.utility.TransIDGenerator;

/**
 * Stateless EJB to send SMS.
 * */

@javax.ejb.Stateless
public class E12SMSComp extends ValidatorEJB implements E12SMSCompLocal, E12SMSCompRemote
{
	
	/**
	 * Represent the type of sms
	 * 
	 * @author Abhishek T
	 */
	public enum SMSType {
		PROMOTIONAL,
		TRANSACTIONAL,
		OTP
	}
	
	// stores what type of SMS should be send
	private SMSType smsType;
	
	// stores SMS url (API link), if provided from "SMSPARAM" table
	private String smsURL;
	
	/**
	 * #smsParamMap contains param name and param value used to send SMS.
	 * */
	HashMap smsParamMap = null;

	String tblName   = "SMSPARAM";
	String prmValue  = "PARAM_VALUE";
	String prmName  = "PARAM_NAME";
	String toParamName = "";
	String textParamName = "";
	String xmlString = "";
	String entityCode = "";
	String entityType = "";
	String formatCode = "";
	String objName = "";
    String senderID = "";
    // Added by Pankaj R on 26-Mar-21 for DLT template template implementation for msg91.com provider [START]
	String templateIdName = "";
	String smsTextType = "";
	String inputVariable = "inputVariable";
	String smsApiKeyName = "";
	// Added by Pankaj R on 26-Mar-21 for DLT template implementation for msg91.com provider [END]
	private String appHashCode;//Added by Pravin k on 1-MAR-19 [For appHash] START

	// Added by AMOL on 27-DEC-28 #S17LLHP003 [To configured 2factor sms service url]
	private String serviceProviderUrl = "";

	UserInfoBean userInfoBean = null;

	//Added by Ravindra C on 10/06/2021 [to define the template id against the sms_format]
	private String templateKeyName ="";
	
	ibase.utility.E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

	public String sendSMS() throws ITMException
	{
		return "";
	}

	//Changed by Pankaj T on 19-12-17 [for multitenancy Added new overloaded method for passing userinfobean object] -Start
	/**
	 * This method used to send SMS 
	 * @param xmlString transaction XML
	 * @param formatCode format code for SMS
	 * @param xtraParams additional employee information
	 * */
	/*public String sendSMS(String xmlString, String formatCode, String xtraParams) throws ITMException
	{
			return sendSMS(xmlString, formatCode, xtraParams, null);	
	}*/
	//Changed by Pankaj T on 19-12-17 [for multitenancy Added new overloaded method for passing userinfobean object] -End

	// Added by Abhishek T on 26-Nov-18 [For preserving previous method signature] START
	public String sendSMS (
			String xmlString, String formatCode,
			String xtraParams, UserInfoBean userInfoBean
			) throws ITMException
	{
		return sendSMS(xmlString, formatCode, xtraParams, SMSType.TRANSACTIONAL, userInfoBean);
	}
	// Added by Abhishek T on 26-Nov-18 [For preserving previous method signature] END

	// Added by Pankaj T on 19-12-17 [for multitenancy Added new overloaded method for passing userinfobean object] - Start	
	// Changed by Abhishek T on 26-Nov-18 [Added new parameter "SMSType"] START
	/**
	 * 
	 * @param xmlString transaction XML
	 * @param formatCode format code for SMS
	 * @param xtraParams additional employee information
	 * @param smsType Type of SMS
	 * @param userInfoBean User information
	 * 
	 * @return return "SEND_SUCCESS" if SMS send successfully, otherwise !"SEND_SUCCESS"
	 * 
	 * @throws ITMException
	 */
	public String sendSMS(
			String xmlString, String formatCode,
			String xtraParams, SMSType smsType,
			UserInfoBean userInfoBean
			) throws ITMException
	{
		BaseLogger.log("3", null,  null, "formatCode["+formatCode+"]");
		BaseLogger.log("3", null,  null, "smsType["+smsType+"]");
		BaseLogger.log("3", null,  null, "xmlString["+xmlString+"]");
		BaseLogger.log("3", null,  null, "userInfoBean["+userInfoBean+"]");

		this.smsType = smsType;
		String resposeStr = "";
		String messageStr = "SEND_SUCCESS";
		boolean isError = false;
		HttpURLConnection connection = null;

		try
		{
			this.userInfoBean = userInfoBean;
			this.xmlString = xmlString;
			this.formatCode = formatCode;
			setUserInfo(userInfoBean);
			Document smsDom = genericUtility.parseString(xmlString);

			//Comment this part to fetch formatCode from method parameter - Ajit
			//this.formatCode = genericUtility.getColumnValue("format_code", smsDom, "1");
			
			//Added by Pravin k on 1-MAR-19 [For appHash] START
			this.appHashCode = genericUtility.getColumnValue("APP_HASH", smsDom);
			System.out.println(this.smsType+" this.smsType :: E12SMSComp :: sendSMS() : " + appHashCode);
			//Added by Pravin k on 1-MAR-19 [For appHash] END

			if(this.formatCode == null || this.formatCode.trim().length() == 0)
			{
				this.formatCode = "MAKEMY_SMS";
			}
			this.objName = getObjNameFromDom(smsDom, "objName" );
			if(evaluateExpression(userInfoBean))
			{
				//Configure SMS parameter 
				ConfigureSMSParam();
				String transDB = userInfoBean.getTransDB();
				
				String mobileNo = E12GenericUtility.checkNull( (String)this.smsParamMap.get(this.toParamName) );
				String smsText = E12GenericUtility.checkNull( (String)this.smsParamMap.get(this.textParamName) );
				String tempId = E12GenericUtility.checkNull( (String)this.smsParamMap.get(this.templateIdName) );
				BaseLogger.log("3", null,  null, "mobileNo:::["+mobileNo+"]");
				BaseLogger.log("3", null,  null, "smsText:::["+smsText+"]");
				BaseLogger.log("3", null,  null, "tempId:::["+tempId+"]");


				//Commented by Ravindra C on 20/11/2020 [Not required, as used SMS_FORMAT] START
				//Added By Ravindra C on 22-06-2020 for SMS Notification Related Changes - Start
				/*if( smsDom != null && mobileNo.length() == 0 && smsText.length()== 0 )
				{
					mobileNo = genericUtility.getColumnValue("MOBILE_NO", smsDom);
					smsText = genericUtility.getColumnValue("SMS_TEXT", smsDom);
				}
				//Added By Ravindra C on 22-06-2020 for SMS Notification Related Changes - End
				
				//Added By Ravindra C on 11-11-2020 to send report Transactional SMS.
				smsParamMap.put(this.toParamName, mobileNo); 
				smsParamMap.put(this.textParamName, smsText);*/
				//Commented by Ravindra C on 20/11/2020 [Not required, as used SMS_FORMAT] END
				
				BaseLogger.log("3",userInfoBean,null,"this.smsParamMap111 ::"+this.smsParamMap);
				if( (mobileNo != null && mobileNo.trim().length() > 0 && !"null".equalsIgnoreCase(mobileNo)) 
						&& ((smsText != null && smsText.trim().length() > 0 && !"null".equalsIgnoreCase(smsText)) || (tempId !=null && tempId.trim().length() > 0)) )
				{
					/*AppConnectParm appConnect = new AppConnectParm();
					InitialContext ctx = new InitialContext(appConnect.getProperty());
					DBAccessLocal dbAccess =(DBAccessLocal)ctx.lookup("ibase/DBAccessEJB/local");*/
					DBAccessEJB dbAccess = new DBAccessEJB();
					
					// Get the SMS URL
					// Changed by AMOL on 27-DEC-18 #S17LLHP003 [To configured 2factor sms service url] [START]
					String smsURL = "";
					if (this.serviceProviderUrl.contains("2factor")) 
					{
						smsURL = fillPlaceHolders(this.serviceProviderUrl);
					}
					else
					{
						smsURL = buildSMSURL();
					}
					// Changed by AMOL on 27-DEC-18 #S17LLHP003 [To configured 2factor sms service url][END]
					
					BaseLogger.log("3",userInfoBean,null,"smsURL: ["+smsURL+"] ");
					InputStreamReader isr;
					URL smsServiceURL = new URL( smsURL );
                    connection = (HttpURLConnection) smsServiceURL.openConnection();
                    // Added by Pankaj R on 26-Mar-21 for DLT template implementation for msg91.com provider [START]
					if(this.smsType == SMSType.TRANSACTIONAL && "T".equalsIgnoreCase(smsTextType))
					{
						BaseLogger.log("3",userInfoBean,null,"smsAPIKeyName: ["+(String)this.smsParamMap.get(this.smsApiKeyName)+"] ");
						connection.setRequestProperty("Content-Type", "application/json");
						connection.setRequestProperty(this.smsApiKeyName, (String)this.smsParamMap.get(this.smsApiKeyName));
                    }
                    // Added by Pankaj R on 26-Mar-21 for DLT template implementation for msg91.com provider [END]
					// Added by Abhishek T on 05-NOV-18 [For setting timeout for connection and read operation] START
					connection.setConnectTimeout(15000);
					connection.setReadTimeout(15000);
					// Added by Abhishek T on 05-NOV-18 [For setting timeout for connection and read operation] END
					BaseLogger.log("3",userInfoBean,null,"smsAPIKeyName: After ");

					String proxyHost = dbAccess.getDBColumnValue(tblName, prmValue, prmName+" ='PROXY_HOST'", transDB); 
					String proxyPort = dbAccess.getDBColumnValue(tblName, prmValue, prmName+" ='PROXY_PORT'", transDB); 
					String proxyUser = dbAccess.getDBColumnValue(tblName, prmValue, prmName+" ='PROXY_USER'", transDB); 
					String proxyPswd = dbAccess.getDBColumnValue(tblName, prmValue, prmName+" ='PROXY_PSWD'", transDB); 
					BaseLogger.log("3",userInfoBean,null,"proxyHost:"+proxyHost+" proxyPort:"+proxyPort+" proxyPort:"+proxyUser+" proxyPort:"+proxyPswd);

					Properties systemSettings = System.getProperties();
					systemSettings.put("http.proxyHost", proxyHost );
					systemSettings.put("http.proxyPort", proxyPort );

					//sun.misc.BASE64Encoder encoder = new sun.misc.BASE64Encoder();
                    //String encodedUserPwd = encoder.encode((proxyUser + ":" + proxyPswd).getBytes());
                    String encodedUserPwd = java.util.Base64.getEncoder().encodeToString((proxyUser + ":" + proxyPswd).getBytes());
					connection.setRequestProperty("Proxy-Authorization", "Basic " + encodedUserPwd);

					connection.setRequestMethod("POST"); 
					connection.setRequestProperty("Content-Length", "" + Integer.toString(smsURL.getBytes().length));

					connection.setDoOutput(true);
					connection.setDoInput(true);
					connection.setUseCaches(false);
					connection.connect();

                    String urlParameters = "";
                    // Added by Pankaj R on 26-Mar-21 for DLT template implementation for msg91.com provider [START]
					if(this.smsType == SMSType.TRANSACTIONAL && "T".equalsIgnoreCase(smsTextType))
					{
						urlParameters = (String)this.smsParamMap.get(this.inputVariable);
						BaseLogger.log("3",userInfoBean,null,"Proxy TRANSACTIONAL:"+urlParameters);						
					
					}
					else if(smsURL.indexOf("?") != -1)
					{
						urlParameters = smsURL.substring(smsURL.indexOf("?") +1);
						BaseLogger.log("3",userInfoBean,null,"Proxy TRANSACTIONAL else:"+urlParameters);						

					}
                    // Added by Pankaj R on 26-Mar-21 for DLT template implementation for msg91.com provider [END]
					BaseLogger.log("3",userInfoBean,null,"urlParameters ::"+urlParameters);

					DataOutputStream wr = new DataOutputStream(connection.getOutputStream());
					wr.writeBytes(urlParameters);
					wr.flush();
					wr.close();

					try 
					{
						InputStream in1 = connection.getInputStream();
						BaseLogger.log("3",userInfoBean,null,"in1 ::"+in1);
						isr = new InputStreamReader(in1);
						BaseLogger.log("3",userInfoBean,null,"isr ::"+isr);

						StringBuffer buffer = new StringBuffer();				
						//String logString = "";	
						int letter = 0;

						while ( (letter = isr.read()) != -1) 
						{
							buffer.append( (char) letter);
						}
						resposeStr = buffer.toString();
						BaseLogger.log("3",userInfoBean,null,"resposeStr ::"+resposeStr);

						if(resposeStr != null && resposeStr.toUpperCase().indexOf("ERROR") != -1)
						{
							isError = true;
							messageStr = getErrorString("", "SMSFAILED", "");
							//Changed by Pankaj T on 04-01-18 [changes for multitenancy]
					        BaseLogger.log("0", userInfoBean, null, "Error detected in SMS response: " + resposeStr);
							generateLog(messageStr, xtraParams, userInfoBean);
						}
						
						//Generating log
						//generateLog(resposeStr, xtraParams);
						
						/*--Log file generation
						
						SimpleDateFormat sdf = new SimpleDateFormat("ddMMyy");
						java.sql.Timestamp currTime =new java.sql.Timestamp(System.currentTimeMillis());
						String dateVal=sdf.format(currTime);
						
						Random rand = new Random(); 
					    long value = Math.round(Math.random() * 100000);
					    
						logString = "Date :" + currTime + "\n" + "Mobile No :" + mobileNo + "\n" + "SMS Text :" + smsText + "\n" + "Response :" + resposeStr;	
						if(!( new File ( CommonConstants.JBOSSHOME  + File.separator + "SMSLog" + File.separator + "smsLog_"+mobileNo+"_"+dateVal+"_"+value+".log" ) ).exists() )
						{
							( new File( CommonConstants.JBOSSHOME  + File.separator + "SMSLog" + File.separator + "smsLog_"+mobileNo+"_"+dateVal+"_"+value+".log" ) ).createNewFile();
						}
						String logFileName = CommonConstants.JBOSSHOME + File.separator + "SMSLog" + File.separator + "smsLog_"+mobileNo+"_"+dateVal+"_"+value+".log";
						BufferedWriter logFileWriter = new BufferedWriter( new FileWriter( logFileName, true ) );
						logFileWriter.newLine();
						logFileWriter.write( logString );
						logFileWriter.flush();
						logFileWriter.close();
						*/
					}
					catch (Exception er) 
					{
						er.printStackTrace();
					}
					dbAccess = null;
				}
				else
				{
					String msg = "Mobile No/ SMSText is null or not defined ";
					BaseLogger.log("3",userInfoBean,null,"Mobile No/ SMSText is null or not defined , SMS can not be send without Mobile No/SMS Text ");

					messageStr = getErrorString("", "SMSPARAM", "");
					isError = true;
					//Changed by Pankaj T on 04-01-18 [changes for multitenancy]
					generateLog(msg, xtraParams, userInfoBean);
				}
			}
			else
			{
				BaseLogger.log("3",userInfoBean,null,"Expression Evaluation failed...........");
				isError = true;//Gaurav Singh on 17-06-2015
				//Changed by Pankaj T on 04-01-18 [changes for multitenancy]
				generateLog("Expression Evaluation failed", xtraParams, userInfoBean);
			}

		}
		catch(Exception e)
		{
			isError = true;
			try
			{
				BaseLogger.log("0", userInfoBean, "", "Exception in E12SMSComp :: sendSMS() :--><--" + e);
				messageStr = getErrorString("", "SMSFAILED", "");
				//Changed by Pankaj T on 04-01-18 [changes for multitenancy]
				generateLog("SMS Send Failed", xtraParams, userInfoBean);
			}
			catch(Exception se)
			{

			}
			BaseLogger.log("0",userInfoBean,null,"Exception ::"+e.getMessage());
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(connection != null)
				{
					connection.disconnect();
				}
				if(!isError)
				{
					//messageStr = getErrorString("", "SMSSUCCESS", "");
					//Changed by Pankaj T on 04-01-18 [changes for multitenancy]
					generateLog("Status : SMS Send Successfully \n"+resposeStr, xtraParams, userInfoBean);
				}
			}
			catch(Exception fe)
			{

			}
		}
		BaseLogger.log("0",userInfoBean,null,"messageStr ::"+messageStr);
		return messageStr;
	}
	// Changed by Abhishek T on 26-Nov-18 [Added new parameter "SMSType"] END
	// Added by Pankaj T on 19-12-17 [for multitenancy Added new overloaded method for passing userinfobean object] - End
	/**
	 * To configure the SMS paramameter to send SMS
	 * */

	private void ConfigureSMSParam()throws ITMException
	{
		try
		{
			buildSMSParamMap();
			setSMSDetails();
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
	}
	/**
	 * This method used to build SMS param map which contains the pramameter name and value
	 * */
	private void buildSMSParamMap()throws ITMException
	{
		Document smsParamDom = null;

		try
		{
			this.smsParamMap = new HashMap();
			String transDB = userInfoBean.getTransDB();

			// Changed by Abhishek T on 26-Nov-18 [for segregating SMS parameters configuration implementation] START
			switch (smsType)
			{
			case OTP:
				buildSMSParamMapOTP(transDB);
				break;

			case PROMOTIONAL:
				BaseLogger.log("3", null, "E12SMSComp", "PROMOTIONAL sms parameters configuration not implemented yet.");
				break;

			case TRANSACTIONAL:
			default:
				buildSMSParamMapTransactional(transDB);
				break;
			}
			// Changed by Abhishek T on 26-Nov-18 [for segregating SMS parameters configuration implementation] END
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
	}

	// Added by Abhishek T on 26-Nov-18 [Separate out source for configuring parameters for transactional SMS] START
	private void buildSMSParamMapTransactional(String transDB)
			throws RemoteException, ITMException {

		DBAccessEJB dbAccess = new DBAccessEJB();
		String smsUserName  	= dbAccess.getDBColumnValue(tblName, prmValue, prmName+" ='USER_VAR_NAME'", transDB);
		String smsUserVal  		= dbAccess.getDBColumnValue(tblName, prmValue, prmName+" ='USER_VAR_VALUE'", transDB);
		String smsPasswdName  	= dbAccess.getDBColumnValue(tblName, prmValue, prmName+" ='PASSWD_VAR_NAME'", transDB);
		String smsPasswdVal  	= dbAccess.getDBColumnValue(tblName, prmValue, prmName+" ='PASSWD_VAR_VALUE'", transDB);
		String smsType       	= dbAccess.getDBColumnValue(tblName, prmValue, prmName+" ='SMSTYPE_VAR_NAME'", transDB);
		String smsTypeVal  		= dbAccess.getDBColumnValue(tblName, prmValue, prmName+" ='SMSTYPE_VAR_VALUE'", transDB);
		String smsProduct  	    = dbAccess.getDBColumnValue(tblName, prmValue, prmName+" ='SMSPRODUCT_VAR_NAME'", transDB);
		String smsProductVal  	= dbAccess.getDBColumnValue(tblName, prmValue, prmName+" ='SMSPRODUCT_VAR_VALUE'", transDB);		
		String smsFromName  	= dbAccess.getDBColumnValue(tblName, prmValue, prmName+" ='FROM_VAR_NAME'", transDB);
		String smsFromVal  		= dbAccess.getDBColumnValue(tblName, prmValue, prmName+" ='FROM_VAR_VALUE'", transDB);
		String smsToName  		= dbAccess.getDBColumnValue(tblName, prmValue, prmName+" ='TO_VAR_NAME'", transDB);
		String smsTextName  	= dbAccess.getDBColumnValue(tblName, prmValue, prmName+" ='MSG_VAR_NAME'", transDB);
		String smsFeedidName  	= dbAccess.getDBColumnValue(tblName, prmValue, prmName+" ='USER_FEEDID_NAME'", transDB);
		String smsFeedidVal  	= dbAccess.getDBColumnValue(tblName, prmValue, prmName+" ='USER_FEEDID_VALUE'", transDB);
		String smsModeVarName  	= dbAccess.getDBColumnValue(tblName, prmValue, prmName+" ='SMS_MODE_VAR_NAME'", transDB);
		String smsModeVarVal  	= dbAccess.getDBColumnValue(tblName, prmValue, prmName+" ='SMS_MODE_VAR_VALUE'", transDB);

		//Changes made by Gulzar on 25/02/15 to include the message type i.e text, picture etc :START
		String msgTypeVarName  	= dbAccess.getDBColumnValue(tblName, prmValue, prmName+" ='MSG_TYPE_VAR_NAME'", transDB);
		String msgTypeVarVal  	= dbAccess.getDBColumnValue(tblName, prmValue, prmName+" ='MSG_TYPE_VAR_VALUE'", transDB);
		//Changes made by Gulzar on 25/02/15 to include the message type i.e text, picture etc :END

		// Added by Abhishek T on 15-May-18 [Added extra parameters, for configuring "http://dashboard.tosms.in/api/sendhttp.php" provider] START
		String smsApiKeyName = dbAccess.getDBColumnValue(tblName, prmValue, prmName+" ='MSG_API_KEY_NAME'", transDB);
		String smsApiKeyValue = dbAccess.getDBColumnValue(tblName, prmValue, prmName+" ='MSG_API_KEY_VALUE'", transDB);

		String smsResFormatName = dbAccess.getDBColumnValue(tblName, prmValue, prmName+" ='RES_FORMAT_NAME'", transDB);
		String smsResFormatValue = dbAccess.getDBColumnValue(tblName, prmValue, prmName+" ='RES_FORMAT_VALUE'", transDB);

		String smsMethodName = dbAccess.getDBColumnValue(tblName, prmValue, prmName+" ='MSG_METHOD_NAME'", transDB);
		String smsMethodValue = dbAccess.getDBColumnValue(tblName, prmValue, prmName+" ='MSG_METHOD_VALUE'", transDB);

		String smsRouteName = dbAccess.getDBColumnValue(tblName, prmValue, prmName+" ='MSG_ROUTE_NAME'", transDB);
		String smsRouteValue = dbAccess.getDBColumnValue(tblName, prmValue, prmName+" ='MSG_ROUTE_VALUE'", transDB);
		// Added by Abhishek T 15-May-18 [Added extra parameters, for configuring "http://dashboard.tosms.in/api/sendhttp.php" provider] END
		// Added by Pankaj R on 26-Mar-21 for DLT template implementation for msg91.com provider [START]
		String smsURL = dbAccess.getDBColumnValue(tblName, prmValue, prmName+"='SMS_SERVICE_URL'", transDB);
		String smsDltIdKey = dbAccess.getDBColumnValue(tblName, prmValue, prmName+"='MSG_DLT_ID_KEY_NAME'", transDB);
		String smsDltIdVal = dbAccess.getDBColumnValue(tblName, prmValue, prmName+"='MSG_DLT_ID_KEY_VALUE'", transDB);
		// Added by Pankaj R on 26-Mar-21 for DLT template implementation for msg91.com provider [END]
		
		//Added by Ravindra C on 10/06/2021 [to define the template id against the sms_format]
		String templateKeyName = dbAccess.getDBColumnValue(tblName, prmValue, prmName+"='MSG_TEMPL_KEY_NAME'", transDB);
		
		this.toParamName = smsToName;
		this.textParamName = smsTextName;
		this.senderID = smsFromVal;
		this.smsApiKeyName = smsApiKeyName;
		//Added by Ravindra C on 10/06/2021 [to define the template id against the sms_format]
		this.templateKeyName = templateKeyName;
        BaseLogger.log( "3", null, "E12SMSComp", "smsUsernameTransaction : ["+ this.smsParamMap.containsKey(smsUserName) +"+]" );
        BaseLogger.log( "3", null, "E12SMSComp", "smsPasswordTransaction : ["+ this.smsParamMap.containsKey(smsPasswdName) +"]" );
        BaseLogger.log( "3", null, "E12SMSComp", "smsUsernameTransaction : ["+ smsUserName +"+]" );
        BaseLogger.log( "3", null, "E12SMSComp", "smsUsernameTransaction : ["+ smsUserVal +"+]" );

		if(!this.smsParamMap.containsKey(smsUserName) && smsUserName.trim().length() > 0)
		{
			this.smsParamMap.put(smsUserName, smsUserVal);
		}
		if(!this.smsParamMap.containsKey(smsPasswdName) && smsPasswdName.trim().length() > 0)
		{
			this.smsParamMap.put(smsPasswdName, smsPasswdVal);
		}
		if(!this.smsParamMap.containsKey(smsType) && smsType.trim().length() > 0)
		{
			this.smsParamMap.put(smsType, smsTypeVal);
		}
		if(!this.smsParamMap.containsKey(smsProduct) && smsProduct.trim().length() > 0)
		{
			this.smsParamMap.put(smsProduct, smsProductVal);
		}		
		if(!this.smsParamMap.containsKey(smsFromName) && smsFromName.trim().length() > 0)
		{
			this.smsParamMap.put(smsFromName, smsFromVal);
		}
		if(!this.smsParamMap.containsKey(smsToName) && smsToName.trim().length() > 0)
		{
			this.smsParamMap.put(smsToName, "");
		}
		if(!this.smsParamMap.containsKey(smsTextName) && smsTextName.trim().length() > 0)
		{
			this.smsParamMap.put(smsTextName, "");
		}
		if(!this.smsParamMap.containsKey(smsFeedidName) && smsFeedidName.trim().length() > 0)
		{
			this.smsParamMap.put(smsFeedidName, smsFeedidVal);
		}
		if(!this.smsParamMap.containsKey(smsModeVarName) && smsModeVarName.trim().length() > 0)
		{
			this.smsParamMap.put(smsModeVarName, smsModeVarVal);
		}
		//Changes made by Gulzar on 25/02/15 to include the message type i.e text, picture etc :START
		if(!this.smsParamMap.containsKey(msgTypeVarName) && msgTypeVarName.trim().length() > 0)
		{
			this.smsParamMap.put(msgTypeVarName, msgTypeVarVal);
		}
		//Changes made by Gulzar on 25/02/15 to include the message type i.e text, picture etc :END

		// Added made by Abhishek T on 15-May-18 [Added extra parameters, for configuring "http://dashboard.tosms.in/api/sendhttp.php" provider] START
		if (smsApiKeyName.length() > 0)
		{
			smsParamMap.put(smsApiKeyName, smsApiKeyValue);
	        BaseLogger.log( "3", null, "E12SMSComp", "smsApiKeyName11 : "+smsParamMap);			
			
		}
		if (smsResFormatName.length() > 0)
		{
			smsParamMap.put(smsResFormatName, smsResFormatValue);
		}
		if (smsMethodName.length() > 0)
		{
			smsParamMap.put(smsMethodName, smsMethodValue);
		}
		if (smsRouteName.length() > 0)
		{
			smsParamMap.put(smsRouteName, smsRouteValue);
		}
        // Added made by Abhishek T on 15-May-18 [Added extra parameters, for configuring "http://dashboard.tosms.in/api/sendhttp.php" provider] END
        // Added by Pankaj R on 26-Mar-21 for DLT template implementation for msg91.com provider [START]
		if (smsDltIdKey.length() > 0)
		{
			smsParamMap.put(smsDltIdKey, smsDltIdVal);
		}
		if(smsURL.length() > 0)
		{
			this.smsURL = smsURL;
        }
        // Added by Pankaj R on 26-Mar-21 for DLT template implementation for msg91.com provider [END]
		dbAccess = null;
	}
	// Added by Abhishek T on 26-Nov-18 [Separate out source for configuring parameters for transactional SMS] END

	// Added by Abhishek T on 26-Nov-18 [Separate out source for configuring parameters for OTP SMS] START
	private void buildSMSParamMapOTP(String transDB)
			throws Exception 
	{

		DBAccessEJB dbAccess = new DBAccessEJB();

		String smsURL = dbAccess.getDBColumnValue(tblName, prmValue, prmName+"='OTP_SERVICE_URL'", transDB);

		this.serviceProviderUrl = smsURL;		

		String authKeyName= dbAccess.getDBColumnValue(tblName, prmValue, prmName+"='MSG_API_KEY_NAME_OTP'", transDB);
		String authKeyValue = dbAccess.getDBColumnValue(tblName, prmValue, prmName+"='MSG_API_KEY_VALUE_OTP'", transDB);

		String messageKeyName = dbAccess.getDBColumnValue(tblName, prmValue, prmName+"='MSG_VAR_NAME_OTP'", transDB);

		String fromKeyName = dbAccess.getDBColumnValue(tblName, prmValue, prmName+"='FROM_VAR_NAME_OTP'", transDB);
		String fromKeyValue = dbAccess.getDBColumnValue(tblName, prmValue, prmName+"='FROM_VAR_VALUE_OTP'", transDB);

		String toKeyValue = dbAccess.getDBColumnValue(tblName, prmValue, prmName+"='TO_VAR_NAME_OTP'", transDB);

		String otpKeyName = dbAccess.getDBColumnValue(tblName, prmValue, prmName+"='OTP_VAR_NAME'", transDB);
		String otpKeyValue = dbAccess.getDBColumnValue(tblName, prmValue, prmName+"='OTP_VAR_VALUE'", transDB);

		String retryName = dbAccess.getDBColumnValue(tblName, prmValue, prmName+"='RETRY_TYPE_VAR_NAME_OTP'", transDB);
		String retryValue = dbAccess.getDBColumnValue(tblName, prmValue, prmName+"='RETRY_TYPE_VAR_VALUE_OTP'", transDB);

		// Added by AMOL on 27-DEC-28 #S17LLHP003 [To configured 2factor sms service url] [START]
		String templateName = dbAccess.getDBColumnValue(tblName, prmValue, prmName+"='TEMPLATE_KEY_NAME_OTP'", transDB);
		String templateValue = dbAccess.getDBColumnValue(tblName, prmValue, prmName+"='TEMPLATE_KEY_VALUE_OTP'", transDB);
		// Added by AMOL on 27-DEC-28 #S17LLHP003 [To configured 2factor sms service url] [END]

		String templateIdName = dbAccess.getDBColumnValue(tblName, prmValue, prmName+"='TEMPLATE_ID_NAME_OTP'", transDB);
		
		this.toParamName = toKeyValue;
		this.textParamName = messageKeyName;
		this.senderID = fromKeyValue;
		this.templateIdName = templateIdName; 
		
        BaseLogger.log( "3", null, "E12SMSComp", "smsUsernameOtp : " );

		// Added by AMOL on 27-DEC-28 #S17LLHP003 [To configured 2factor sms service url] [START]
		if(templateName.trim().length() > 0)
		{
			smsParamMap.put(templateName, templateValue);
		}
		// Added by AMOL on 27-DEC-28 #S17LLHP003 [To configured 2factor sms service url] [END]

		if(authKeyName.trim().length() > 0)
		{
			smsParamMap.put(authKeyName, authKeyValue);
		}
		if(fromKeyName.trim().length() > 0)
		{
			smsParamMap.put(fromKeyName, fromKeyValue);
		}
		if(retryName.trim().length() > 0)
		{
			smsParamMap.put(retryName, retryValue);
		}

		if(otpKeyName.trim().length() > 0 && otpKeyValue.length() > 0) {
			String resultValue = customizeDataStr(otpKeyValue, xmlString);
			smsParamMap.put(otpKeyName, resultValue);
		}

		if (smsURL.length() > 0)
		{
			this.smsURL = smsURL;
		}
	}
	// Added by Abhishek T on 26-Nov-18 [Separate out source for configuring paramters for OTP SMS] END

	/**
	 * This method used to build SMS URL to send SMS
	 * */
	private	String buildSMSURL()throws ITMException
	{
		String paramName="", paramValue="", smsParamStr="", mobileNo="", smsUrlStr="";
		int i=1 ,mapSize=0;
		try
		{
			//Added By Ravindra C on 11-11-2020 to get enterprise wise URL - Start 
			String smsUrlInEnterprise ="";
			if(checkNull(userInfoBean.getTransDB()).length() > 0)
			{
				DBAccessEJB accessEJB = new DBAccessEJB();
				smsUrlInEnterprise = accessEJB.getDBColumnValue("ENTERPRISE", "SMS_URL", "ENTERPRISE ='"+ userInfoBean.getEnterprise() +"'", userInfoBean.getTransDB());
			}
			if(checkNull(smsUrlInEnterprise).length() > 0)
			{
				smsUrlStr = smsUrlInEnterprise;
			}
			else 
			{
				//Added By Ravindra C on 11-11-2020 to get enterprise wise URL - End
				//Changes done by Gaurav Singh on 13-JUL-2016 [ setIBASEHOME only when TOMCAT_HOME is null | Start ]
				//CommonConstants.setIBASEHOME();
				if(CommonConstants.TOMCAT_HOME == null || CommonConstants.TOMCAT_HOME.trim().length() == 0)
				{
					CommonConstants.setIBASEHOME();
				}
				//Changes done by Gaurav Singh on 13-JUL-2016 [ setIBASEHOME only when TOMCAT_HOME is null | End ]

				// Changed by Abhishek T [For setting SMS service url from "SMSPARAM" table] START
				smsUrlStr = this.smsURL;
				if (smsUrlStr == null || smsUrlStr.trim().length() == 0) {
					smsUrlStr = CommonConstants.SMSURL;
				}
				// Changed by Abhishek T [For setting SMS service url from "SMSPARAM" table] END
			}
			//smsUrlStr = this.smsURL;
            BaseLogger.log( "3", null, "E12SMSComp", "smsUrlStr : ["+ smsUrlStr +"]" );
            // Added by Pankaj R on 26-Mar-21 for DLT template implementation for msg91.com provider [START]
			if(!(this.smsType == SMSType.TRANSACTIONAL && "T".equalsIgnoreCase(smsTextType)))
			{
				if(this.smsParamMap != null)
				{
					mapSize = this.smsParamMap.size();
				}

				if( mapSize > 0 )
				{
					Iterator it = this.smsParamMap.entrySet().iterator();
					while (it.hasNext())
					{
						Map.Entry pairs = (Map.Entry)it.next();

						paramName  = (String)pairs.getKey() == null ?"":(String)pairs.getKey();
						paramValue = (String)pairs.getValue() == null ?"":(String)pairs.getValue();
                        
						paramValue = paramValue.replace("+","%2B");
						paramValue = java.net.URLEncoder.encode(paramValue);

						if(i == mapSize )
						{
							smsParamStr = smsParamStr + paramName + "=" + paramValue;
							BaseLogger.log("2",null,null,"##### FINAL SMS URL Query Before for"+paramName);												
							BaseLogger.log("2",null,null,"##### FINAL SMS URL Query Before for1"+paramValue);												
						
						}
						else
						{
							smsParamStr = smsParamStr + paramName + "=" + paramValue + "&";
							BaseLogger.log("2",null,null,"##### FINAL SMS URL Query Before else for"+paramName);												
							BaseLogger.log("2",null,null,"##### FINAL SMS URL Query Before else for1"+paramValue);																			
						}
						i++;
					}
				}
				if (smsUrlStr.indexOf("?") != -1 )
				{
					smsUrlStr = smsUrlStr + "&" +smsParamStr;
					BaseLogger.log("2",null,null,"##### FINAL SMS URL Query SMS"+smsUrlStr);					
				
				}
				else
				{
					smsUrlStr = smsUrlStr  + "?" +smsParamStr;
					BaseLogger.log("2",null,null,"##### FINAL SMS URL Query SMS1"+smsUrlStr);	
				
				}
            }
            // Added by Pankaj R on 26-Mar-21 for DLT template implementation for msg91.com provider [END]
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		BaseLogger.log("2",null,null,"##### FINAL SMS URL Query String11 :: "+smsUrlStr);
		return smsUrlStr;
	}
	/**
	 * This method used to get the SMS details from transaction XML and set in the param MAP
	 * */
	private void setSMSDetails()throws ITMException
	{
		BaseLogger.log("3", null,  null, "setSMSDetails method called");
		ArrayList smsDetailList = null;

		String sendTo = "";
		String smsHeader = "";
		String smsBody = "";
		String smsFooter = "";

		String smsText = "";
		String templateId = "";

		try
		{
			/*AppConnectParm appConnect = new AppConnectParm();
			InitialContext ctx = new InitialContext(appConnect.getProperty());
			DBAccessLocal dbAccess =(DBAccessLocal)ctx.lookup("ibase/DBAccessEJB/local");*/
			DBAccessEJB dbAccess = new DBAccessEJB();
			smsDetailList = dbAccess.getSMSDetailList(this.formatCode, this.userInfoBean);

			BaseLogger.log("3",null,null,"[E12SMSComp] SMS detail found for format code :"+this.formatCode+":");
			BaseLogger.log("3",null,null,"[E12SMSComp] smsDetailList  : ["+ smsDetailList +"]:");

			BaseLogger.log("3",null,null,"this.toParamName =["+this.toParamName+"]");
			BaseLogger.log("3",null,null,"this.textParamName =["+this.textParamName+"]");
			BaseLogger.log("3",null,null,"smsDetailList.size() : ["+ smsDetailList.size() +"]");

			if (smsDetailList.size() > 0)
			{
				String to = "";
				String cc = "";
				String bcc = "";
				this.smsTextType = (String)smsDetailList.get(4);
				if ((String)smsDetailList.get(0) != null )
				{
					to = (String)smsDetailList.get(0);
				}
				if (to.length() > 0)
				{
					StringBuffer toAddrBuff = new StringBuffer();
					ArrayList tokens = genericUtility.getTokenList(to,",");
					BaseLogger.log("3",null,null,"tokens "+tokens);
					for( int i=0;i< tokens.size(); i++)
					{
						String currToken = (String)tokens.get(i);
						BaseLogger.log("3",null,null,"currToken "+currToken);
						String argType = "";
						if ( currToken.indexOf("{") != -1)
						{
							BaseLogger.log("3",null,null,"To with '{' :["+currToken+"]");
							if (currToken.charAt(1) == '(' )
							{
								argType = currToken.substring(currToken.indexOf("(")+1, currToken.indexOf(")"));
								if(argType.length() == 1)
								{
									this.entityType = argType;
								}
								else
								{
									this.entityType = argType.substring(0, 1);
								}
							}
							toAddrBuff.append(getSMSToAddr(argType, currToken.substring(currToken.indexOf(")")+1, currToken.length() - 1))).append(",");
						}
						//Start - Added changes here 0n 19/12/24 by Ajit
						else if(currToken.indexOf("df_") != -1) {
						    BaseLogger.log("3", null, null, "To with 'df_' :[" + currToken + "]");
						    int startBracket = currToken.indexOf("<");
						    int endBracket = currToken.indexOf(">");
						    if (startBracket != -1 && endBracket != -1) {
						        String trimmedToken = currToken.substring(startBracket, endBracket + 1);
								BaseLogger.log("2",null,null,"E12SMSComp.sendSMS trimmedToken:: ["+trimmedToken+"]");						        
						        String argument = customizeDataStr(trimmedToken, this.xmlString);
								BaseLogger.log("2",null,null,"E12SMSComp.sendSMS argument:: ["+argument+"]");						        
						        String functionName = currToken.substring(0, startBracket);
								BaseLogger.log("2",null,null,"E12SMSComp.sendSMS functionName:: ["+functionName+"]");						        
						        String result = executeSQLFunction(functionName, argument, this.userInfoBean);
								BaseLogger.log("2",null,null,"E12SMSComp.sendSMS result:: ["+result+"]");						        
						        toAddrBuff.append(result).append(",");
						    }
						}
						//End - Added changes till here 0n 19/12/24 by Ajit
						else if ( currToken.indexOf("<") != -1 )
						{
							BaseLogger.log("3",null,null,"To with '<' :["+currToken+"]");
							toAddrBuff.append(customizeDataStr(currToken, this.xmlString)).append(",");
						}
						else if ( currToken.indexOf("[") != -1 )
						{
							BaseLogger.log("3",null,null,"To with '[' :["+currToken+"]");
							if (currToken.charAt(1) == '(' )
							{
								if(argType.length() == 1)
								{
									this.entityType = argType;
								}
								else
								{
									this.entityType = argType.substring(0, 1);
								}
								currToken = currToken.substring(currToken.indexOf(")")+1, currToken.length() - 1);
							}
							else
							{
								currToken = currToken.substring(1, currToken.length() - 1);
							}
							if (currToken.equals("ROLE_CODE"))
							{
								toAddrBuff.append(getRoleCodeSMSToAddr(this.entityType)).append(",");
							}
							else
							{
								toAddrBuff.append(getSMSToAddr(this.entityType, currToken)).append(",");
							}
						}
						else
						{
							toAddrBuff.append(currToken).append(",");
						}
					}
					if ( sendTo != null && !sendTo.equalsIgnoreCase("null") && sendTo.trim().length() > 0 )
					{
						sendTo =  sendTo +","+toAddrBuff.toString();						
					}
					else
					{
						sendTo = toAddrBuff.toString();						
					}
					BaseLogger.log("3",null,null, "sendTo "+sendTo.toString() );
					if(sendTo.endsWith(","))
					{
						sendTo = sendTo.substring(0, sendTo.length() -1);
					}	

					this.smsParamMap.put(this.toParamName, (sendTo == null ? "" : sendTo));
                }
				//Added by Ravindra C on 10/06/2021 [to define the template id against the sms_format] START
				if( (String)smsDetailList.get(5) != null && smsTextType == null)
				{
					this.smsParamMap.put( templateKeyName, (String)smsDetailList.get(5));
				}
				//Added by Ravindra C on 10/06/2021 [to define the template id against the sms_format] END
				
                // Added by Pankaj R on 26-Mar-21 for DLT template implementation for msg91.com provider [START]				
				if(smsTextType != null && "T".equalsIgnoreCase(smsTextType))
				{
					if ( (String)smsDetailList.get(2) != null )
					{
						smsBody = (String)smsDetailList.get(2);
						BaseLogger.log("3",null,null, "smsBody : "+smsBody.toString() );
						templateId = smsBody;
						if (this.smsType == SMSType.TRANSACTIONAL)
						{
							if(smsBody.contains("<MOBILE_NO>"))
							{
								smsBody = smsBody.replace("<MOBILE_NO>", sendTo);
							}
							String originalString = customizeDataStr(smsBody, this.xmlString);
                            BaseLogger.log("3",null,null, "\nFinal originalString : "+originalString );
                            this.smsParamMap.put(this.inputVariable, originalString);
						}
					}
					this.smsParamMap.put(this.templateIdName, templateId);
                    // Added by Pankaj R on 26-Mar-21 for DLT template implementation for msg91.com provider [END]
                }
				else
				{
					if ( (String)smsDetailList.get(1) != null )
					{
						smsHeader = (String)smsDetailList.get(1);
						//Start - Added changes here 0n 19/12/24 by Ajit
						if(smsHeader.indexOf("df_") != -1) {
						    BaseLogger.log("3", null, null, "To with 'df_' for smsHeader ---->>:[" + smsHeader + "]");
						    int startBracket = smsHeader.indexOf("<");
						    int endBracket = smsHeader.indexOf(">");
						    if (startBracket != -1 && endBracket != -1) {
						    	int i = smsHeader.indexOf("df_");
								BaseLogger.log("2",null,null,"index i value:: ["+i+"]");						        

						        String trimmedToken = smsHeader.substring(startBracket, endBracket + 1);
								BaseLogger.log("2",null,null,"E12SMSComp.sendSMS smsHeader trimmedToken:: ["+trimmedToken+"]");						        
						        String argument = customizeDataStr(trimmedToken, this.xmlString);
								BaseLogger.log("2",null,null,"E12SMSComp.sendSMS argument:: ["+argument+"]");						        
						        String functionName = smsHeader.substring(i, startBracket);
								BaseLogger.log("2",null,null,"E12SMSComp.sendSMS functionName:: ["+functionName+"]");						        
						        String result = executeSQLFunction(functionName, argument, this.userInfoBean);
								BaseLogger.log("2",null,null,"E12SMSComp.sendSMS smsHeader result:: ["+result+"]");
								smsHeader = smsHeader.replaceAll("df_getUserName<.*?>", result);
								BaseLogger.log("2",null,null,"E12SMSComp.sendSMS smsHeader:: ["+smsHeader+"]");						        

						    }
						}
						//End - Added changes till here 0n 19/12/24 by Ajit
						if (smsHeader.indexOf("<") != -1) 
						{
							smsHeader = customizeDataStr(smsHeader, this.xmlString);
						}
					}
					if ( (String)smsDetailList.get(2) != null )
					{
						smsBody = (String)smsDetailList.get(2);
						//Start - Added changes here 0n 19/12/24 by Ajit
						if(smsBody.indexOf("df_") != -1) {
						    BaseLogger.log("3", null, null, "To with 'df_' for sms body :[" + smsBody + "]");
						    int startBracket = smsBody.indexOf("<");
						    int endBracket = smsBody.indexOf(">");
						    if (startBracket != -1 && endBracket != -1) {
						    	int i = smsBody.indexOf("df_");
						        String trimmedToken = smsBody.substring(startBracket, endBracket + 1);
								BaseLogger.log("2",null,null,"E12SMSComp.sendSMS smsBody trimmedToken:: ["+trimmedToken+"]");						        
						        String argument = customizeDataStr(trimmedToken, this.xmlString);
								BaseLogger.log("2",null,null,"E12SMSComp.sendSMS argument:: ["+argument+"]");						        
						        String functionName = smsBody.substring(i, startBracket);
								BaseLogger.log("2",null,null,"E12SMSComp.sendSMS functionName:: ["+functionName+"]");						        
						        String result = executeSQLFunction(functionName, argument, this.userInfoBean);
								BaseLogger.log("2",null,null,"E12SMSComp.sendSMS result:: ["+result+"]");
								smsBody = smsBody.replaceAll("df_getUserName<.*?>", result);
								BaseLogger.log("2",null,null,"E12SMSComp.sendSMS smsBody:: ["+smsBody+"]");						        

						    }
						}
						//End - Added changes till here 0n 19/12/24 by Ajit
						else if (smsBody.indexOf("<") != -1) 
						{
							smsBody = customizeDataStr(smsBody, this.xmlString);
						}
					}
					if ( (String)smsDetailList.get(3) != null )
					{
						smsFooter = (String)smsDetailList.get(3);
						//Start - Added changes here 0n 19/12/24 by Ajit
						if(smsFooter.indexOf("df_") != -1) {
						    BaseLogger.log("3", null, null, "To with 'df_' for smsFooter :[" + smsFooter + "]");
						    int startBracket = smsFooter.indexOf("<");
						    int endBracket = smsFooter.indexOf(">");
						    if (startBracket != -1 && endBracket != -1) {
						    	int i = smsFooter.indexOf("df_");
						        String trimmedToken = smsFooter.substring(startBracket, endBracket + 1);
								BaseLogger.log("2",null,null,"E12SMSComp.sendSMS trimmedToken:: ["+trimmedToken+"]");						        
						        String argument = customizeDataStr(trimmedToken, this.xmlString);
								BaseLogger.log("2",null,null,"E12SMSComp.sendSMS argument:: ["+argument+"]");						        
						        String functionName = smsFooter.substring(i, startBracket);
								BaseLogger.log("2",null,null,"E12SMSComp.sendSMS functionName:: ["+functionName+"]");						        
						        String result = executeSQLFunction(functionName, argument, this.userInfoBean);
								BaseLogger.log("2",null,null,"E12SMSComp.sendSMS result:: ["+result+"]");
								smsFooter = smsFooter.replaceAll("df_getUserName<.*?>", result);
								BaseLogger.log("2",null,null,"E12SMSComp.sendSMS smsFooter:: ["+smsFooter+"]");						        

						    }
						}
						//End - Added changes till here 0n 19/12/24 by Ajit
						else if (smsFooter.indexOf("<") != -1) 
						{
							smsFooter = customizeDataStr(smsFooter, this.xmlString);
						}
					}
					if(smsHeader != null && smsHeader.trim().length() > 0)
					{
						smsText = smsText + smsHeader;
					}
					if(smsBody != null && smsBody.trim().length() > 0)
					{
						if(smsText != null && smsText.trim().length() > 0)
						{
							smsText = smsText + "\n" + smsBody;
						}
						else
						{
							smsText = smsText + smsBody;
						}
					}
					if(smsFooter != null && smsFooter.trim().length() > 0)
					{
						if(smsText != null && smsText.trim().length() > 0)
						{
							smsText = smsText + "\n" + smsFooter;
						}
						else
						{
							smsText = smsText + smsFooter;
						}
					}
					BaseLogger.log("3",null,null,"smsText ::"+smsText);
					//Added by Pravin k on 1-MAR-19 [For appHash] START
					if (smsType == SMSType.OTP) {
	                    // Added by Pankaj R on 11-Dec-20 to not include <#> and appHashCode in message if the appHashCode is null [START]
	                    if(E12GenericUtility.checkNull(appHashCode).length() > 0) 
	                    {
	                        smsText =  "<#> " +smsText+ "\n" + appHashCode;
	                    }
	                    // Added by Pankaj R on 11-Dec-20 to not include <#> and appHashCode in message if the appHashCode is null [END]
						System.out.println("E12SMSComp :: setSMSDetails() : SMSLength : " + smsText.getBytes().length);

						if (smsText != null && smsText.getBytes().length > 140) {
							// System.err.println("OTP message is greater than 140 bytes, which is ");
							System.err.printf(
									"OTP message length is %s bytes, which is greater than standard size (i.e. %s)",
									smsText.getBytes().length, 140
									);
						}
					}
					//Added by Pravin k on 1-MAR-19 [For appHash] END

					this.smsParamMap.put(this.textParamName, (smsText == null?"":smsText));
				}

			}
			dbAccess = null;
			BaseLogger.log("3",null,null,"sms parameter map::"+this.smsParamMap);
			
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null,"Exception :ITMSMSInfo :email :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
			}
			catch (Exception e)
			{
				BaseLogger.log("0",null,null,"===>"+e.getMessage());
			}
		}
	}
	//Start - Creates this method to execute SQL function on 19/12/24 by Ajit
	private String executeSQLFunction(String functionName, String argument, UserInfoBean userInfoBean) throws ITMException {
		BaseLogger.log("2",null,null,"Calling executeSQLFunction method ["+functionName +"::"+argument+"]");
	    Connection conn = null;
	    CallableStatement callableStatement = null;
	    ActionHandlerEJB actionHandlerEJB = new ActionHandlerEJB();
	    String result = null;
	    ConnDriver connDriver = new ConnDriver();

	    try {
	        conn = connDriver.getConnectDB(userInfoBean.getTransDB());

	        String sql = "{ ? = call " + functionName + "(?) }";
			BaseLogger.log("2",null,null,"E12SMSComp.executeSQLFunction functionBody ["+sql+"]");
	        callableStatement = conn.prepareCall(sql);
	        callableStatement.registerOutParameter(1, Types.VARCHAR);
	        callableStatement.setString(2, argument);
	        callableStatement.execute();
	        result = callableStatement.getString(1);
			BaseLogger.log("2",null,null,"E12SMSComp.executeSQLFunction result:: ["+result+"]");
	    } 
	    catch (Exception e) {
	    	BaseLogger.log("3", null, null, "Exception in E12SMSComp.executeSQLFunction [" + E12GenericUtility.getStackTrace(e) + "]");
            throw new ITMException(e);	    } 
	    finally {
	        try {
	            if (callableStatement != null) {
	                callableStatement.close();
	            }
	            if (conn != null) {
	                conn.close();
	            }
	        } catch (SQLException se) {
	            se.printStackTrace(); 
	        }
	    }
	    return result; 
	}
	//End - Creates this method to execute SQL function on 19/12/24 by Ajit


	/**
	 * This method used to get the mobile no based on the arg type
	 * @argType argument Type can be E-Employee, S-Supplier, C-Customer, P-Sales Person
	 * @argName argument Name is the column name of used to place in where condition
	 * */
	private String getSMSToAddr(String argType, String argName) throws ITMException
	{
		BaseLogger.log("2",null,null,"[getSMSToAddr]argType :"+argType+": argName :"+argName+":");
		String retSmsMobNo = "";
		String transDB = "";
		try
		{

			String masterTable = null;
			String whereFieldName = null;
			String selFieldName = "MOBILE_NO";
			String responsibleFor = "";

			String entityType = "";
			String whereCondition = "";

			if( this.userInfoBean != null )
			{
				transDB = this.userInfoBean.getTransDB();
			}

			Document dom = genericUtility.parseString(this.xmlString);

			if(argType != null && argType.trim().length() > 0)
			{
				entityType = argType.substring(0, 1);
			}
			if(argType != null && argType.trim().length() > 1)
			{
				responsibleFor = argType.substring(1, 2);
			}
			this.entityCode = getValueOfField(dom, argName.toLowerCase());

			if (entityType.equalsIgnoreCase("C"))
			{
				masterTable = "CUSTOMER";
				////argName = (argName == null || "".equals(argName))?"CUST_CODE":argName;
				if(responsibleFor == null || responsibleFor.trim().length() == 0)
				{
					whereFieldName = "CUST_CODE";
					selFieldName = "TELE3";
				}
			}
			else if (entityType.equalsIgnoreCase("S"))
			{
				masterTable = "SUPPLIER";
				////argName = (argName == null || "".equals(argName))?"SUPP_CODE":argName;
				if(responsibleFor == null || responsibleFor.trim().length() == 0)
				{
					whereFieldName = "SUPP_CODE";
					selFieldName = "TELE3";
				}
			}
			else if (entityType.equalsIgnoreCase("E"))
			{
				masterTable = "EMPLOYEE";
				////argName = (argName == null || "".equals(argName))?"EMP_CODE":argName;
				if(responsibleFor == null || responsibleFor.trim().length() == 0)
				{
					whereFieldName = "EMP_CODE";
					selFieldName = "MOBILE_NO";
				}
			}
			else if (entityType.equalsIgnoreCase("P"))
			{
				masterTable = "SALES_PERS";
				////argName = (argName == null || "".equals(argName))?"SALES_PERS":argName;

				if(responsibleFor == null || responsibleFor.trim().length() == 0)
				{
					whereFieldName = "SALES_PERS";
					selFieldName = "TELE3";
				}
			}
			else if (argType.equalsIgnoreCase("T"))
			{
				masterTable = "TRANSPORTER";
				//argName = (argName == null || "".equals(argName))?"SALES_PERS":argName;
				if(responsibleFor == null || responsibleFor.trim().length() == 0)
				{
					whereFieldName = "TRAN_CODE";
					selFieldName = "TELE3";
				}
			}
			// Changed by Abhishek T on 25-April-18 [New entity type "U" added] START
			else if (argType.equalsIgnoreCase("U"))
			{
				masterTable = "USERS";
				// Added by Abhishek T on 23-May-18 [Setting tran DB as "Driver", for USERS table] START
				transDB = "Driver";
				// Added by Abhishek T on 23-May-18 [Setting tran DB as "Driver", for USERS table] END

				if(responsibleFor == null || responsibleFor.trim().length() == 0)
				{
					whereFieldName = "CODE";
					selFieldName = "MOBILE_NO";
				}
			}
			//Added by Kailash P. for checking entity type 'G' condition[02-Jan-19]START
			else if (argType.equalsIgnoreCase("G"))
			{
				masterTable = "STRG_CUSTOMER";
				if(responsibleFor == null || responsibleFor.trim().length() == 0)
				{
					whereFieldName = "SC_CODE";
					selFieldName = "MOBILE_NO";
				}
			}
			//Added by Sagar B. Kailash P. for checking entity type 'G' condition[02-Jan-19]END
			// Changed by Abhishek T on 25-April-18 [New entity type "U" added] END

			if(responsibleFor != null && responsibleFor.trim().length() > 0)
			{
				retSmsMobNo = getMobileNo(entityType, entityCode, responsibleFor);
			}
			else
			{
				/*AppConnectParm appConnect = new AppConnectParm();
				InitialContext ctx = new InitialContext(appConnect.getProperty());
				DBAccessLocal dbAccess =(DBAccessLocal)ctx.lookup("ibase/DBAccessEJB/local");*/
				DBAccessEJB dbAccess = new DBAccessEJB();
				String whereFieldValue = getValueOfField(dom, argName.toLowerCase());
				whereCondition = whereFieldName + " = '" + whereFieldValue + "'";
				retSmsMobNo = dbAccess.getDBColumnValue(masterTable, selFieldName, whereCondition, transDB);
				dbAccess = null;
			}

		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null,"Exception :E12SMSComp :getSMS :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		return retSmsMobNo;
	}

	/**
	 * This method used to get the mobile no based on the ROLE_CODE mentioned in the send_to
	 * @argType argument Type can be E-Employee, S-Supplier, C-Customer, P-Sales Person
	 * */
	private String getRoleCodeSMSToAddr(String argType) throws ITMException
	{
		BaseLogger.log("2",null,null,"[ITMSMSInfo] argType getRoleCodeSMSAddr :"+argType+":");
		String retSmsAddr = "";
		try
		{
			String masterTable = null;
			String whereFieldName = null;
			String selFieldName = null;

			if (argType.equalsIgnoreCase("C"))
			{
				masterTable = "CUSTOMER";
				whereFieldName = "CUST_CODE";
				selFieldName = "TELE3";
			}
			else if (argType.equalsIgnoreCase("S"))
			{
				masterTable = "SUPPLIER";
				whereFieldName = "SUPP_CODE";
				selFieldName = "TELE3";
			}
			else if (argType.equalsIgnoreCase("E"))
			{
				masterTable = "EMPLOYEE";
				whereFieldName = "EMP_CODE";
				selFieldName = "MOBILE_NO";
			}
			else if (argType.equalsIgnoreCase("P"))
			{
				masterTable = "SALES_PERS";
				whereFieldName = "SALES_PERS";
				selFieldName = "TELE3";
			}

			/*AppConnectParm appConnect = new AppConnectParm();
			InitialContext ctx = new InitialContext(appConnect.getProperty());
			DBAccessLocal dbAccess =(DBAccessLocal)ctx.lookup("ibase/DBAccessEJB/local");*/
			DBAccessEJB dbAccess = new DBAccessEJB();
			//This method returns the mobile no 
			retSmsAddr = dbAccess.getMobileNo(selFieldName, masterTable, whereFieldName, this.entityCode);
			dbAccess = null;
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null,"Exception :ITMSMSInfo :getEmailAddr :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		return retSmsAddr;
	}
	/**
	 * This method used to get the value for field from XML dom
	 * @dom XML Document object 
	 * @fieldName field Name 
	 * */
	private String getValueOfField(Document dom, String fieldName)throws ITMException
	{
		BaseLogger.log("2",null,null,"Getting value of ["+fieldName +"]");
		String fieldValue = null;		
		try
		{
			Node currField = dom.getElementsByTagName(fieldName).item(0);
			if (currField != null)
			{
				BaseLogger.log("3",null,null,"["+fieldName +"] found ");
				if (currField.getFirstChild() != null)
				{
					if (currField.getFirstChild().getNodeType() == Node.ELEMENT_NODE)
					{
						fieldValue = new ibase.utility.E12GenericUtility().serializeDom(currField, true);
					}
					else
					{
						fieldValue = currField.getFirstChild().getNodeValue();
					}
				}
			}
			else
			{
				BaseLogger.log("3",null,null,"Node ["+fieldName +"] not found ");
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null,"Exception :ITMSMSInfo :getValueOfField() :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		return fieldValue;
	}
	/**
	 * This method used to get the field name from XML String
	 * @domStr XML String 
	 * @fieldName field Name 
	 * */
	private String getValueOfFieldFromStr(String domStr, String fieldName)throws ITMException
	{
		String fieldValue = "";		
		try
		{
			if (domStr.indexOf(fieldName) != -1 )
			{
				String startTag = "<"+fieldName+">";
				String endTag = "</"+fieldName+">";
				fieldValue = domStr.substring((domStr.indexOf(startTag)+startTag.length()), domStr.indexOf(endTag));
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null,"Exception :ITMSMSInfo :getValueOfField() :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		return fieldValue.trim();
	}

	/**
	 * This method used to extract the field value from XML String
	 * @fieldName field name 
	 * @domString XML String 
	 * */
	private String customizeDataStr(String fieldName, String domString)throws Exception//prerna
	{
		String fieldValue ="";
		String replacedFieldValue ="";
		String currMsgstr ="";
		StringBuffer msgBuff = new StringBuffer();
		try
		{
			BaseLogger.log("3",null,null, "fieldName:: "+fieldName);
			BaseLogger.log("3",null,null, "domString:: "+domString);


			if(fieldName.indexOf("<") != -1)
			{
				StringTokenizer msgToken = new StringTokenizer(fieldName,">");
				BaseLogger.log("3",null,null, "msgToken:: "+msgToken);
				while(msgToken.hasMoreTokens())
				{
					currMsgstr = msgToken.nextToken();
					if(currMsgstr.indexOf("<") != -1 )
					{
						int startBracket = currMsgstr.indexOf("<");
						msgBuff.append(currMsgstr.substring(0, startBracket));
						fieldValue = currMsgstr.substring(startBracket+1, currMsgstr.length());
						replacedFieldValue = getValueOfFieldFromDom(domString, fieldValue);
						BaseLogger.log("3",null,null, "replacedFieldValue:: "+replacedFieldValue);

						msgBuff.append(replacedFieldValue);
					}
				}
				if(!(fieldName.endsWith(">")))
				{
					String tempStr = fieldName.substring(fieldName.lastIndexOf(">")+1,fieldName.length());
					BaseLogger.log("3",null,null, "tempStr:: "+tempStr);
					msgBuff.append(tempStr);
				}
			}
			else
			{
				msgBuff.append(fieldName);
			}
			BaseLogger.log("3",null,null," msg buff ["+msgBuff.toString());
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		return (msgBuff.toString());
	}

	/**
	 * This method used to extract the field value from XML String
	 * @domStre XML String 
	 * @fieldRequired field name
	 * */
	private String getValueOfFieldFromDom(String domStr,String fieldRequired)throws Exception
	{
		Node parentNode = null;
		Document dom =null;
		String childNodeName = null;	
		String childNodeName1 = null;
		String fieldValue = null;
		String fromNode =null;
		ArrayList taskList = new ArrayList();
		try
		{
			dom = genericUtility.parseString(domStr);
			if(fieldRequired.indexOf(".") != -1)
			{
				fromNode = fieldRequired.substring(0,fieldRequired.indexOf("."));
				fieldRequired = fieldRequired.substring(fieldRequired.indexOf(".")+1,fieldRequired.length());
			}
			else
			{
				fromNode = (fromNode == null)?"Detail1":fromNode;
			}			
			NodeList detailList = dom.getElementsByTagName(fromNode);
			int detListLength = detailList.getLength();
			for(int ctr = 0; ctr < detListLength; ctr++)
			{
				Node currDetailNode = detailList.item(ctr);
				NodeList childList = currDetailNode.getChildNodes();
				int childCtr = childList.getLength();
				for(int chCnt=0; chCnt<childCtr; chCnt++)
				{
					Node childNode = childList.item(chCnt);
					childNodeName = childNode.getNodeName();
					if(childNodeName.equalsIgnoreCase(fieldRequired) && childNode.getFirstChild() != null)
					{
						fieldValue = childNode.getFirstChild().getNodeValue().trim();

						// Added by AMOL on 27-DEC-28 #S17LLHP003 [To configured 2factor sms service url] [START]
						if("OTP".equalsIgnoreCase(fieldRequired))
						{
							smsParamMap.put("otp", fieldValue);
						}
						// Added by AMOL on 27-DEC-28 #S17LLHP003 [To configured 2factor sms service url] [END]
						BaseLogger.log("3",null,null,"fieldRequired ["+fieldRequired+"] fieldValue  ["+fieldValue+"]");
					}					
				}
			}
			fieldValue = (fieldValue == null)?"":fieldValue;
		}
		catch(Exception e)
		{
			throw e;			
		}
		return (fieldValue);
	}
	/**
	 * This method is used to generate log on success/failed
	 * @param responseStr
	 * @param xtraParams
	 * @throws RemoteException
	 * @throws ITMException
	 */
	//Changed by Pankaj T on 04-01-18 [changes for multitenancy]
	private void generateLog(String responseStr, String xtraParams, UserInfoBean userInfo)throws RemoteException, ITMException
	{
		ConnDriver mConnDriver = null;
		Connection mConnection = null;
		PreparedStatement pStmt = null;
		ResultSet mRs = null;
		String transDB = "";
		String status = "";
		String mobileNo = "";
		String smsText = "";
		try
		{
			mConnDriver = new ConnDriver();
			//Changed by Pankaj T on 04-01-18 [changes for multitenancy]
			transDB = userInfo.getTransDB();
			mConnection = mConnDriver.getConnectDB(transDB); 

			String tranID = generateTranID(mConnection, xtraParams);

			if(tranID != null && tranID.trim().length() > 0)
			{
				// Commented and Changes done by Gaurav Singh on 17-06-2015 [START] 
				//String mobileNo = (String)this.smsParamMap.get(this.toParamName);
				//String smsText = (String)this.smsParamMap.get(this.textParamName);

				if (smsParamMap != null && !"".equals(smsParamMap))
				{
					mobileNo = (String)this.smsParamMap.get(this.toParamName);
					smsText = (String)this.smsParamMap.get(this.textParamName);
				}
				// Commented and Changes done by Gaurav Singh on 17-06-2015 [END] 

				String insertSql = "INSERT INTO SMS_LOG (TRAN_ID, OBJ_NAME, SMS_SEND_DATE, SEND_TO, SENDER_ID, STATUS, SMS_MSG, CHG_DATE,CHG_USER,CHG_TERM) VALUES(?,?,?,?,?,?,?,?,?,?)";
				pStmt = mConnection.prepareStatement(insertSql);

				pStmt.setString(1, tranID);
				pStmt.setString(2, this.objName);
				pStmt.setTimestamp(3, new java.sql.Timestamp(System.currentTimeMillis()));
				pStmt.setString(4, mobileNo);
				pStmt.setString(5, this.senderID);
				pStmt.setString(6, responseStr);
				pStmt.setString(7, smsText);
				pStmt.setTimestamp(8, new java.sql.Timestamp(System.currentTimeMillis()));
				pStmt.setString(9, getValueFromXTRA_PARAMS(xtraParams, "loginCode"));
				pStmt.setString(10, getValueFromXTRA_PARAMS(xtraParams, "termId"));

				int insCnt = pStmt.executeUpdate();

				if(insCnt > 0)
				{
					mConnection.commit();
				}
			}
			else
			{
				BaseLogger.log("3",null,null,"Transaction id is null.......");
			}


		}
		catch (ITMException itme)
		{ 
			System.err.println("ITMException :generateLog :\n"); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{ 
			System.err.println("Exception :generateLog :\n"+e.getMessage()); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{					
					if(mRs != null)
					{
						mRs.close();
						mRs = null;
					}
					if(pStmt != null)
					{
						pStmt.close();
						pStmt = null;
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :generateLog :\n"+e.getMessage()); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
	}
	/**
	 * This method is used to get the object name from dom
	 * @param dom
	 * @param attribute
	 * @return
	 * @throws RemoteException
	 * @throws ITMException
	 */
	private String getObjNameFromDom( Document dom, String attribute ) throws RemoteException,ITMException
	{
		NodeList detailList = null;
		Node currDetail = null;
		String objName = "";
		int detailListLength = 0;

		try
		{
			detailList = dom.getElementsByTagName("Detail1");
			detailListLength = detailList.getLength();
			for (int ctr = 0; ctr < detailListLength; ctr++)
			{
				currDetail = detailList.item(ctr);
				objName = currDetail.getAttributes().getNamedItem(attribute).getNodeValue();
			}
		}
		catch ( Exception e )
		{
			throw new ITMException(e);
		}
		BaseLogger.log("2",null,null,"objName =["+objName+"]");
		return objName;
	}
	/**
	 * This method is used to generate the unique id 
	 * @param conn
	 * @param xtraParams
	 * @return String
	 */
	private String generateTranID( Connection conn, String xtraParams )
	{
		String sprsTravelTranID = "";
		PreparedStatement pStmt = null;
		ResultSet rSet = null;
		String refSer="";
		String tranIdCol="";
		String keyString="";
		ibase.utility.E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		try
		{
			String transSql = "SELECT REF_SER,TRAN_ID_COL,KEY_STRING FROM TRANSETUP WHERE TRAN_WINDOW  = 'w_sms_log'";

			pStmt = conn.prepareStatement(transSql);
			rSet = pStmt.executeQuery();

			if( rSet.next() )
			{
				refSer = (rSet.getString("REF_SER") == null) ?"":rSet.getString("REF_SER").trim();
				tranIdCol = (rSet.getString("TRAN_ID_COL") == null) ?"":rSet.getString("TRAN_ID_COL").trim();
				keyString = (rSet.getString("KEY_STRING") == null) ?"":rSet.getString("KEY_STRING").trim();
			}
			BaseLogger.log("3",null,null,"refSer["+refSer+"]tranIdCol["+tranIdCol+"]keyString["+keyString+"]");

			TransIDGenerator tranIDGenerator = new TransIDGenerator("<Root></Root>",getValueFromXTRA_PARAMS(xtraParams, "loginCode"), CommonConstants.DB_NAME);
			sprsTravelTranID = tranIDGenerator.generateTranSeqID( refSer,tranIdCol,keyString,conn) ;
		}
		catch( Exception exp )
		{
			BaseLogger.log("2",null,null,"Exception In generateTranID......");
			exp.printStackTrace();
		}
		finally
		{
			try
			{
				if( rSet != null )
				{
					rSet.close();
					rSet.close();
				}
				if( pStmt != null )
				{
					pStmt.close();
					pStmt.close();
				}
			}
			catch( Exception expRsc )
			{
				expRsc.printStackTrace();
			}
		}
		return sprsTravelTranID;
	}

	//Changed by Pankaj T on 19-12-17 [for multitenancy passing userinfobean object] -
	/**
	 * This method is used to get the SMS_EXPR value and send for evaluation
	 * @return
	 * @throws ITMException
	 */
	private boolean evaluateExpression(UserInfoBean userInfoBean) throws ITMException
	{
		BaseLogger.log("2",userInfoBean,null,"evaluateExpression is called....");
		boolean isEvaluation = false;
		String exprStr = "";
		String tableName = "SMS_FORMAT";
		String columnName = "SMS_EXPR";
		String condition = "";
		try
		{
			/*AppConnectParm appConnect = new AppConnectParm();
			InitialContext ctx = new InitialContext(appConnect.getProperty());
			DBAccessLocal dbAccess =(DBAccessLocal)ctx.lookup("ibase/DBAccessEJB/local");*/
			DBAccessEJB dbAccess = new DBAccessEJB();			
			condition = " FORMAT_CODE ='"+this.formatCode+"'";
			exprStr = dbAccess.getDBColumnValue(tableName, columnName, condition, userInfoBean.getTransDB());

			if(exprStr != null && exprStr.trim().length() > 0)
			{
				E12EvaluateExpression e12EvalExpr = new E12EvaluateExpression();

				isEvaluation = e12EvalExpr.evaluateExpression(exprStr, this.xmlString);
			}
			else
			{
				isEvaluation = true;
			}
			dbAccess = null;
		}
		catch (Exception e)
		{
			BaseLogger.log("2",userInfoBean,null,"Exception :E12SMSComp :evaluateExpression :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		return isEvaluation;
	}
	/**
	 * This method is used to get the mobile no based on the parameter supplied
	 * @param entityType
	 * @param entityCode
	 * @param responsibleFor
	 * @return
	 * @throws ITMException
	 */
	private String getMobileNo(String entityType, String entityCode, String responsibleFor) throws ITMException
	{
		String mobileNo = "";
		Connection conn = null;
		ConnDriver connDriver = null;
		PreparedStatement pstmtMob = null;
		ResultSet rsMob = null;
		try
		{
			int count = 1;
			connDriver = new ConnDriver();
			// conn = connDriver.getConnectDB("Driver");
			conn = connDriver.getConnectDB(userInfoBean.getTransDB());

			String mobileNoSql = "SELECT MOBILE_NO FROM ENTITY_CONTACT WHERE ENTITY_TYPE = ? AND ENTITY_CODE = ? AND RESPONSIBLE_FOR = ? ";
			pstmtMob = conn.prepareStatement(mobileNoSql);
			pstmtMob.setString(1, entityType);
			pstmtMob.setString(2, entityCode);
			pstmtMob.setString(3, responsibleFor);
			rsMob = pstmtMob.executeQuery();

			while(rsMob.next())
			{
				if(count == 1)
				{
					mobileNo = (rsMob.getString("MOBILE_NO") == null)?"":rsMob.getString("MOBILE_NO").trim();
				}
				else
				{
					mobileNo = mobileNo + ","+ ((rsMob.getString("MOBILE_NO") == null)?"":rsMob.getString("MOBILE_NO").trim()); 
				}
				count++;
			}

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(conn != null)
				{
					if(rsMob != null)
					{
						rsMob.close();
						rsMob = null;
					}
					if(pstmtMob != null)
					{
						pstmtMob.close();
						pstmtMob = null;
					}
					conn.close();
					conn = null;
				}
			}
			catch(Exception e1)
			{

			}
		}
		BaseLogger.log("3",null,null,"mobileNo = ["+mobileNo+"]");
		return mobileNo;
	}

	// Added by AMOL on 27-DEC-28 #S17LLHP003 [To configured 2factor sms service url] [START]
	/**
	 * This method replace placeholder with actual values.
	 *  
	 * @param smsUrl Url
	 * 
	 * @return Given url with place holder filled
	 */
	private String fillPlaceHolders(String smsUrl)
	{

		try
		{
			for (Object key : smsParamMap.keySet())
			{
				String value = E12GenericUtility.checkNull((String) smsParamMap.get(key));

				String placeHolder = "{" + key + "}";

				smsUrl = smsUrl.replace(placeHolder, value);
			}
		}
		catch (Exception ex)
		{
			BaseLogger.log("0", null, null, "#### Exception in E12SMSComp :: getNewSmsUrl : [" + ex + "]");
		}

		return smsUrl;
	}
	// Added by AMOL on 27-DEC-28 #S17LLHP003 [To configured 2factor sms service url] [END]
	
	private String checkNull( String nullStr )
	{
		return E12GenericUtility.checkNull(nullStr);
	}
}